/********************************************************************************
*
* LoRa    : ES920LR3
* TX Button ON
*
*  MaiaR create
*
********************************************************************************/

#include <M5Unified.h>
#include "LoRa.h"

// ####################################################################
// 構成に合わせて1ヶ所の先頭の // を削除してください。

// 1. GROVE
// #define LoRa_VIA_GROVE // LoRa UNIT をGrove端子に接続している
#define No_VIA_GROVE   // LoRa UNIT をGrove端子に接続していない

// ############################################################################################

#define TSIZE 1

#if defined(ARDUINO_M5STACK_STICKC_PLUS)
  #define ROT 3
  #define TSIZE 2
  String msg = "Click the button";
  #ifdef LoRa_VIA_GROVE
    #define RX_pin 33    // LoRa UNIT via GROVE
    #define TX_pin 32    // LoRa UNIT via GROVE
    #define RESET_pin -1 // No RESET Pin
    #define BOOT_pin -1  // No Boot Pin
  #else
    #define RX_pin 26    // LoRa HAT
    #define TX_pin 0     // LoRa HAT
    #define RESET_pin -1 // No RESET Pin
    #define BOOT_pin -1  // No Boot Pin
  #endif
#elif defined(ARDUINO_M5STACK_STICKC_PLUS2)
  #define ROT 3
  #define TSIZE 2
  String msg = "Click the button";
  #ifdef LoRa_VIA_GROVE
    #define RX_pin 33    // LoRa UNIT via GROVE
    #define TX_pin 32    // LoRa UNIT via GROVE
    #define RESET_pin -1 // No RESET Pin
    #define BOOT_pin -1  // No Boot Pin
  #else
    #define RX_pin 26    // LoRa HAT
    #define TX_pin 0     // LoRa HAT
    #define RESET_pin -1 // No RESET Pin
    #define BOOT_pin -1  // No Boot Pin
  #endif
#elif defined(ARDUINO_M5STACK_STICKC)
  #define ROT 3
  #define TSIZE 1
  String msg = "Click the button";
  #ifdef LoRa_VIA_GROVE
    #define RX_pin 33    // LoRa UNIT via GROVE
    #define TX_pin 32    // LoRa UNIT via GROVE
    #define RESET_pin -1 // No RESET Pin
    #define BOOT_pin -1  // No Boot Pin
  #else
    #define RX_pin 26    // LoRa HAT
    #define TX_pin 0     // LoRa HAT
    #define RESET_pin -1 // No RESET Pin
    #define BOOT_pin -1  // No Boot Pin
  #endif
#elif defined(ARDUINO_M5STACK_ATOMS3)
  #define ROT 1
  #define TSIZE 1
  String msg = "Click the button";
  #ifdef LoRa_VIA_GROVE
    #define RX_pin 1     // LoRa UNIT via GROVE
    #define TX_pin 2     // LoRa UNIT via GROVE
    #define RESET_pin -1 // No RESET Pin
    #define BOOT_pin -1  // No Boot Pin
  #else
    #define RX_pin 5     // LoRa KIT
    #define TX_pin 6     // LoRa KIT
    #define RESET_pin 7  // LoRa KIT
    #define BOOT_pin 39  // LoRa KIT
  #endif
#elif defined(ARDUINO_M5STACK_ATOM)
  #define ROT 1
  #define Btn BtnA
  String msg = "";
  #ifdef LoRa_VIA_GROVE
    #define RX_pin 32    // LoRa UNIT via GROVE
    #define TX_pin 26    // LoRa UNIT via GROVE
    #define RESET_pin -1 // No RESET Pin
    #define BOOT_pin -1  // No Boot Pin
  #else
    #define RX_pin 22    // LoRa KIT
    #define TX_pin 19    // LoRa KIT
    #define RESET_pin 23 // LoRa KIT
    #define BOOT_pin 21  // LoRa KIT
  #endif
#elif defined(ARDUINO_M5STACK_CORE)
  #define ROT 1
  #define TSIZE 2
  String msg = "Click the button A";
  #ifdef LoRa_VIA_GROVE
    #define RX_pin 22    // LoRa UNIT via GROVE
    #define TX_pin 21    // LoRa UNIT via GROVE
    #define RESET_pin -1 // No RESET Pin
    #define BOOT_pin -1  // No Boot Pin
  #else
    #define RX_pin 16    // stack LoRa MODULE
    #define TX_pin 17    // stack LoRa MODULE
    #define RESET_pin 13 // stack LoRa MODULE
    #define BOOT_pin 22  // stack LoRa MODULE
  #endif
#elif defined(ARDUINO_M5STACK_CORE2)
  #define ROT 1
  #define TSIZE 2
  String msg = "Click the button A";
  #ifdef LoRa_VIA_GROVE
    #define RX_pin 33    // LoRa UNIT via GROVE
    #define TX_pin 32    // LoRa UNIT via GROVE
    #define RESET_pin -1 // No RESET Pin
    #define BOOT_pin -1  // No Boot Pin
  #else
    #define RX_pin 13    // stack LoRa MODULE
    #define TX_pin 14    // stack LoRa MODULE
    #define RESET_pin 19 // stack LoRa MODULE
    #define BOOT_pin 22  // stack LoRa MODULE
  #endif
#elif defined(ARDUINO_M5STACK_CORES3)
  #define ROT 1
  #define BtnA BtnPWR
  #define TSIZE 2
  String msg = "Click the power button";
  #ifdef LoRa_VIA_GROVE
    #define RX_pin 18    // LoRa UNIT via GROVE PortC
    #define TX_pin 17    // LoRa UNIT via GROVE PortC
    #define RESET_pin -1 // No RESET Pin
    #define BOOT_pin -1  // No Boot Pin
  #else
    #define RX_pin 18    // stack LoRa MODULE
    #define TX_pin 17    // stack LoRa MODULE
    #define RESET_pin 7  // stack LoRa MODULE
    #define BOOT_pin 11  // stack LoRa MODULE
  #endif
#elif defined(ARDUINO_M5STACK_CAPSULE)
  #define ROT 1
  #define TSIZE 1
  String msg = "";
  #define RX_pin 15    // LoRa UNIT via GROVE
  #define TX_pin 13    // LoRa UNIT via GROVE
  #define RESET_pin -1 // No RESET Pin
  #define BOOT_pin -1  // No Boot Pin
#elif defined(ARDUINO_M5STACK_NANO_C6)
  #define ROT 1
  #define TSIZE 1
  String msg = "";
  #define RX_pin  1    // LoRa UNIT via GROVE
  #define TX_pin  2    // LoRa UNIT via GROVE
  #define RESET_pin -1 // No RESET Pin
  #define BOOT_pin -1  // No Boot Pin
#endif




void setup() {
  auto cfg = M5.config();
  // cfg.internal_button = true;
  M5.begin(cfg);
  LoRaInit(RX_pin, TX_pin, RESET_pin, BOOT_pin);
  M5.Display.setRotation(ROT);
  M5.Display.setTextSize(TSIZE);
  M5.Display.println(msg);
}

void loop() {
  M5.update();
  if (M5.BtnA.wasClicked()) {
    LoRaCommand("Button ON");
    M5.Display.fillScreen(BLACK);
    delay(100);
    M5.Display.setCursor(0, 0);
    M5.Display.println(msg);
  }
}
