/********************************************************************************
*
* LoRa    : ES920LR3
* sensor  : ENV III / ENV IV
* library : M5Unit-ENV 1.3.1
*
********************************************************************************/

// ####################################################################
// 構成に合わせて2ヶ所の先頭の // を削除してください。

// 1. GROVE
// #define LoRa_VIA_GROVE // Grove端子に LoRa UNIT を接続
#define ENV_VIA_GROVE  // Grove端子に ENV UNIT を接続

// 2. ENV III / ENV IV
// #define ENVIII
#define ENVIV
// ####################################################################

//----------------------------------------------------------
#if defined(ARDUINO_M5STACK_CORES3)
// * M5Stack CoreS3 with LoRa Module
  #define ROT 1
  #define TSIZE 4
  #define RPOS 180
  #define SX 270
  #define SY 35
  #define SR 15
  #define SCL_pin 1    // ENV III via Grove PortA
  #define SDA_pin 2    // ENV III via Grove PortA
  #define RX_pin 18    // stack LoRa MODULE
  #define TX_pin 17    // stack LoRa MODULE
  #define RESET_pin 7  // stack LoRa MODULE
  #define BOOT_pin 11  // stack LoRa MODULE

//-----------------------------------------------------------
#elif defined(ARDUINO_M5STACK_STICKC)
// * M5StickC  with LoRa UNIT and ENVIII HAT / LoRa HAT and ENVIII UNIT
  #define ROT 3
  #define TSIZE 2
  #define RPOS 62
  #define SX 135
  #define SY 35
  #define SR 8
  #ifdef LoRa_VIA_GROVE // LoRa UNIT via Grove and ENV III HAT
    #define SCL_pin 26    // ENV III HAT
    #define SDA_pin 0     // ENV III HAT
    #define RX_pin 33     // LoRa UNIT via Grove
    #define TX_pin 32     // LoRa UNIT via Grove
    #define RESET_pin -1  // No RESET Pin
    #define BOOT_pin -1   // No Boot Pin
  #else                 // ENV III Unit via Grove and LoRa HAT
    #define SCL_pin 33    // ENV III via Grove
    #define SDA_pin 32    // ENV III via Grove
    #define RX_pin 26     // LoRa HAT
    #define TX_pin 0      // LoRa HAT
    #define RESET_pin -1  // No RESET Pin
    #define BOOT_pin -1   // No Boot Pin
  #endif

//---------------------------------------------------------------
#elif defined(ARDUINO_M5STACK_STICKC_PLUS) || defined(ARDUINO_M5STACK_STICKC_PLUS2)
// * M5StickC Plus / Plus2 with LoRa UNIT and ENVIII HAT / LoRa HAT and ENVIII UNIT
  #define ROT 3
  #define TSIZE 2
  #define RPOS 62
  #define SX 135
  #define SY 35
  #define SR 8
  #ifdef LoRa_VIA_GROVE // LoRa UNIT via Grove and ENV III HAT
    #define SCL_pin 26    // ENV III HAT
    #define SDA_pin 0     // ENV III HAT
    #define RX_pin 33     // LoRa UNIT via Grove
    #define TX_pin 32     // LoRa UNIT via Grove
    #define RESET_pin -1  // No RESET Pin
    #define BOOT_pin -1   // No Boot Pin
  #else                 // ENV III Unit via Grove and LoRa HAT
    #define SCL_pin 33    // ENV III via Grove
    #define SDA_pin 32    // ENV III via Grove
    #define RX_pin 26     // LoRa HAT
    #define TX_pin 0      // LoRa HAT
    #define RESET_pin -1  // No RESET Pin
    #define BOOT_pin -1   // No Boot Pin
  #endif

//---------------------------------------------------------------
#elif defined(ARDUINO_M5STACK_ATOMS3)
// * M5Stack ATOM S3  with LoRa KIT and ENVIII UNIT
  #define ROT 1
  #define TSIZE 2
  #define RPOS 100
  #define SX 100
  #define SY 80
  #define SR 8
  #define SCL_pin 1
  #define SDA_pin 2
  #define RX_pin 5    // LoRa KIT
  #define TX_pin 6    // LoRa KIT
  #define RESET_pin 7 // LoRa KIT
  #define BOOT_pin 39 // LoRa KIT

//----------------------------------------------------------
#elif defined(ARDUINO_M5STACK_ATOM)
// * M5Stack ATOM  with LoRa KIT and ENVIII UNIT
  #define ROT 1
  #define TSIZE 2
  #define RPOS 100
  #define SX 100
  #define SY 80
  #define SR 8
  #define SCL_pin 32
  #define SDA_pin 26
  #define RX_pin 22    // LoRa KIT
  #define TX_pin 19    // LoRa KIT
  #define RESET_pin 23 // LoRa KIT
  #define BOOT_pin 21  // LoRa KIT

//--------------------------------------------------------
#elif defined(ARDUINO_M5STACK_CORE2)
// * M5Stack Core2    with LoRa Module and ENVIII UNIT
  #define ROT 1
  #define TSIZE 4
  #define RPOS 180
  #define SX 270
  #define SY 35
  #define SR 15
  #define SCL_pin 33
  #define SDA_pin 32
  #define RX_pin 13    // stack LoRa MODULE
  #define TX_pin 14    // stack LoRa MODULE
  #define RESET_pin 19 // stack LoRa MODULE
  #define BOOT_pin 22  // stack LoRa MODULE

//------------------------------------------------------
#elif defined(ARDUINO_M5STACK_CORE)
// * M5Stack Core    with LoRa Module/LoRa UNIT
  #define ROT 1
  #define TSIZE 4
  #define RPOS 180
  #define SX 270
  #define SY 35
  #define SR 15
  #define SCL_pin 22
  #define SDA_pin 21
  #define RX_pin 16    // stack LoRa MODULE
  #define TX_pin 17    // stack LoRa MODULE
  #define RESET_pin 13 // stack LoRa MODULE
  #define BOOT_pin 22  // stack LoRa MODULE
  
#endif
//-----------------------------------------------------------------

#include <M5Unified.h>
#include "M5UnitENV.h"
#include "LoRa.h"

#ifdef ENVIII
  SHT3X sht;
  QMP6988 xmp;
  #define SHT_I2C_ADDR SHT3X_I2C_ADDR
  #define XMP_I2C_ADDR QMP6988_SLAVE_ADDRESS_L
#elif defined ENVIV
  SHT4X sht;
  BMP280 xmp;
  #define SHT_I2C_ADDR SHT40_I2C_ADDR_44
  #define XMP_I2C_ADDR BMP280_I2C_ADDR
#endif


float tmp = 0.0;
float hum = 0.0;
float pressure = 0.0;

void setup() {
  auto cfg = M5.config();
  M5.begin(cfg);
  // Wire.end();
  sht.begin(&Wire, SHT_I2C_ADDR, SDA_pin, SCL_pin, 400000U);
  xmp.begin(&Wire, XMP_I2C_ADDR, SDA_pin, SCL_pin, 400000U);
  LoRaInit(RX_pin, TX_pin, RESET_pin, BOOT_pin);
  M5.Display.setRotation(ROT);
  M5.Display.setTextSize(TSIZE);
}

void loop() {
  if (sht.update()){
    tmp = sht.cTemp;
    hum = sht.humidity;
  } else {
    tmp = 0;
    hum = 0;
  }
  if (xmp.update()) {
    // tmp = xmp.cTemp;
    // hum = xmp.humidity;
    pressure = xmp.pressure / 100;
  } else {
    // tmp = 0;
    // hum = 0;
    pressure = 0;
  }
  
  M5.Display.fillRect(0,20,100,60,BLACK); //Fill the screen with black (to clear the screen).  将屏幕填充黑色(用来清屏)
  M5.Display.setCursor(0,18);
  M5.Display.printf("T:%2.1f 'C\r\nH:%2.1f %%  \r\nP:%4.0f hPa\r\n", tmp, hum, pressure);
  M5.Display.fillCircle(SX, SY, SR, RED);
  Serial.printf("T: %2.1f ℃  \r\nH:   %2.1f ％  \r\nP: %4.0f hPa \r\n---\n", tmp, hum, pressure);
  LoRaCommand("MC"+String(tmp)+" "+String(hum)+((pressure < 1000)? "  ":" ")+String(pressure));
  delay(400);
  M5.Display.fillCircle(SX, SY, SR, BLACK);
  delay(5000);
}
