/********************************************************************************
*
* LoRa    : ES920LR3
* receive data display
*
********************************************************************************/

// ####################################################################
// 構成に合わせて1ヶ所の先頭の // を削除してください。
// 1. GROVE
// #define LoRa_VIA_GROVE // LoRa UNIT を接続している
#define No_VIA_GROVE   // LoRa UNIT を使用していない
// ####################################################################


#include <M5Unified.h>
#include "LoRa.h"


//----------------------------------------------------------
#if defined(ARDUINO_M5STACK_CORES3)
// * M5Stack CoreS3 with LoRa Module / LoRa UNIT
  #define ROT 1
  #define TSIZE 4
  #define RPOS 180
  #define SX 270
  #define SY 35
  #define SR 15
  #ifdef LoRa_VIA_GROVE
    #define RX_pin 18    // LoRa UNIT via GROVE PortC
    #define TX_pin 17    // LoRa UNIT via GROVE PortC
    #define RESET_pin -1 // No RESET Pin
    #define BOOT_pin -1  // No Boot Pin
  #else
    #define RX_pin 18    // stack LoRa MODULE
    #define TX_pin 17    // stack LoRa MODULE
    #define RESET_pin 7  // stack LoRa MODULE
    #define BOOT_pin 11  // stack LoRa MODULE
  #endif

//-----------------------------------------------------------
#elif defined(ARDUINO_M5STACK_CORE)
// * M5Stack Core    with LoRa Module / LoRa UNIT
  #define ROT 1
  #define TSIZE 4
  #define RPOS 180
  #define SX 270
  #define SY 35
  #define SR 15
  #ifdef LoRa_VIA_GROVE
    #define RX_pin 22    // LoRa UNIT via GROVE
    #define TX_pin 21    // LoRa UNIT via GROVE
    #define RESET_pin -1 // No RESET Pin
    #define BOOT_pin -1  // No Boot Pin
  #else
    #define RX_pin 16    // stack LoRa MODULE
    #define TX_pin 17    // stack LoRa MODULE
    #define RESET_pin 13 // stack LoRa MODULE
    #define BOOT_pin 22  // stack LoRa MODULE
  #endif

//------------------------------------------------------------
#elif defined(ARDUINO_M5STACK_CORE2)
  #define ROT 1
  #define TSIZE 4
  #define RPOS 180
  #define SX 180
  #define SY 140
  #define SX 270
  #define SY 35
  #define SR 15
  #ifdef LoRa_VIA_GROVE
    #define RX_pin 33    // LoRa UNIT via Grove
    #define TX_pin 32    // LoRa UNIT via Grove
    #define RESET_pin -1 // No RESET Pin
    #define BOOT_pin -1  // No Boot Pin
  #else
    #define RX_pin 13    // stack LoRa MODULE
    #define TX_pin 14    // stack LoRa MODULE
    #define RESET_pin 19 // stack LoRa MODULE
    #define BOOT_pin 22  // stack LoRa MODULE
  #endif

//----------------------------------------------------------
#elif defined(ARDUINO_M5STACK_ATOMS3)
// * M5Stack ATOM S3  with LoRa KIT / LoRa UNIT
  #define ROT 1
  #define TSIZE 2
  #define RPOS 100
  #define SX 100
  #define SY 80
  #define SR 8
  #ifdef LoRa_VIA_GROVE
    #define RX_pin 1     // LoRa UNIT via GROVE
    #define TX_pin 2     // LoRa UNIT via GROVE
    #define RESET_pin -1 // No RESET Pin
    #define BOOT_pin -1  // No Boot Pin
  #else
    #define RX_pin 5     // LoRa KIT
    #define TX_pin 6     // LoRa KIT
    #define RESET_pin 7  // LoRa KIT
    #define BOOT_pin 39  // LoRa KIT
  #endif

//-------------------------------------------------------------
#elif defined(ARDUINO_M5STACK_STICKC_PLUS) || defined(ARDUINO_M5STACK_STICKC_PLUS2)
// * M5StickC Plus / Plus2   with LoRa HAT / LoRa UNIT
  #define ROT 3
  #define TSIZE 3
  #define RPOS 100
  #define SX 210
  #define SY 30
  #define SR 12
  #ifdef LoRa_VIA_GROVE
    #define RX_pin 33    // LoRa UNIT via GROVE
    #define TX_pin 32    // LoRa UNIT via GROVE
    #define RESET_pin -1 // No RESET Pin
    #define BOOT_pin -1  // No Boot Pin
  #else
    #define RX_pin 26    // LoRa HAT
    #define TX_pin 0     // LoRa HAT
    #define RESET_pin -1 // No RESET Pin
    #define BOOT_pin -1  // No Boot Pin
  #endif

//------------------------------------------------------------
#elif defined(ARDUINO_M5STACK_STICKC)
// * M5StickC         with LoRa HAT / LoRa UNIT
  #define ROT 3
  #define TSIZE 2
  #define RPOS 62
  #define SX 135
  #define SY 35
  #define SR 8
  #ifdef LoRa_VIA_GROVE
    #define RX_pin 33    // LoRa UNIT via GROVE
    #define TX_pin 32    // LoRa UNIT via GROVE
    #define RESET_pin -1 // No RESET Pin
    #define BOOT_pin -1  // No Boot Pin
  #else
    #define RX_pin 26    // LoRa HAT
    #define TX_pin 0     // LoRa HAT
    #define RESET_pin -1 // No RESET Pin
    #define BOOT_pin -1  // No Boot Pin
  #endif

#endif
//-------------------------------------------------------------


void setup() {
  auto cfg = M5.config();
  M5.begin(cfg);
  LoRaInit(RX_pin, TX_pin, RESET_pin, BOOT_pin);
  M5.Display.setRotation(ROT);
  M5.Display.setTextSize(TSIZE);
  M5.Display.fillScreen(BLACK);
  M5.Display.setTextColor(WHITE);
  M5.Display.setCursor(0, 20);
  M5.Display.println("LoRa");
  M5.Display.println("Display");
  M5.Display.println("Stand-by");
}

void loop(){
  if (Serial2.available()) {
    String rxs = Serial2.readString();
    Serial.print(rxs);
    char Buf[5];
    rxs.toCharArray(Buf, 5);
    int16_t rssi = strtol(Buf,NULL,16);
    rxs = rxs.substring(4);
    M5.Display.fillScreen(BLACK);
    M5.Display.fillCircle(SX, SY, SR, GREEN);
    M5.Display.setCursor(0, 8);
    if (rxs.length() > 12){
      M5.Display.println("T:" + rxs.substring( 2, 6 ) + " 'C " );
      M5.Display.println("H:" + rxs.substring( 8,12 ) + " % "  );
      if (rxs.length() > 16){
        M5.Display.println("P:" + rxs.substring(14,18 ) + " hPa ");
      }
    } else {
      M5.Display.println(rxs);
    }
    M5.Display.setCursor(0, RPOS);
    M5.Display.print("R: ");
    M5.Display.print(rssi);
    M5.Display.print(" dBm ");
    M5.Speaker.tone(4000, 100);
    delay(400);
    M5.Display.fillCircle(SX, SY, SR, BLACK);
  }
}
