//
//  920MHz LoRa/FSK RF module ES920LR3 
//  Firmware updater
//   for M5Stack UNIT
//
//  MaiaR Create

#include <M5Unified.h>

#if defined(ARDUINO_M5STACK_CORE)
#define RX_pin 22
#define TX_pin 21
#elif defined(ARDUINO_M5STACK_CORE2)
#define RX_pin 33
#define TX_pin 32
#endif


void BootReset(){
  pinMode(RX_pin, OUTPUT);
  pinMode(TX_pin, OUTPUT);
  digitalWrite(RX_pin, LOW);
  digitalWrite(TX_pin, LOW);
  delay(1000);
  pinMode(TX_pin, INPUT); // boot mode
  delay(50);
  pinMode(RX_pin, INPUT);
}

void NormalReset(){
  pinMode(RX_pin, OUTPUT);
  pinMode(TX_pin, OUTPUT);
  digitalWrite(RX_pin, LOW);
  digitalWrite(TX_pin, LOW);
  delay(1000);
  pinMode(RX_pin, INPUT);
  pinMode(TX_pin, INPUT); // normal mode
}


void Command(String s){
  Serial2.println(s);
  Serial2.flush();
  delay(10);
}


void bootmode(){
  M5.Display.fillRect(0,70,320,80,BLACK);
  BootReset();
  M5.Display.setTextSize(1);
  M5.Display.drawCentreString("Firmware update", 160, 70, 4);
  Serial.end();
  Serial2.end();
  Serial.begin(115200, SERIAL_8E1);
  Serial2.begin(115200, SERIAL_8E1, RX_pin, TX_pin);
}

void normalmode(){
  String rx;
  M5.Display.fillRect(0,70,320,30,BLACK);
  NormalReset();
  M5.Display.setTextSize(1);
  M5.Display.drawCentreString("    version check    ", 160, 70, 4);
  delay(100);
  Serial.end();
  Serial2.end();
  Serial2.setTimeout(50);
  Serial.begin(115200, SERIAL_8N1);
  Serial2.begin(115200, SERIAL_8N1, RX_pin, TX_pin);
  delay(100);
  Command("2");
  rx = Serial2.readString();

  while(1){
    M5.update();
    Command("v");
    rx = Serial2.readString();
    M5.Display.drawCentreString(rx, 160, 120, 4);
    if (M5.BtnA.wasPressed()) break;
  }
  
  bootmode();
}


void setup() {
  auto cfg = M5.config();
  M5.begin(cfg);
  
  M5.Display.setTextSize(1);
  M5.Display.fillScreen(BLACK);
  M5.Display.drawCentreString("ES920LR3", 160, 20, 4);
  M5.Display.setTextSize(2);
  M5.Display.drawCentreString("update",    65, 220, 1);
  M5.Display.drawCentreString("check", 160, 220, 1);

  bootmode();
}

void loop() {
  M5.update();
  if (M5.BtnB.wasPressed()){
    normalmode();
  }
  
  if (Serial2.available()) {
    Serial.write(Serial2.read());
  }
  if (Serial.available()) {
    Serial2.write(Serial.read());
  } 
}
